﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['et']={"application":"Rich Text Editor","editor":"Rikkalik tekstiredaktor","editorPanel":"Rikkaliku tekstiredaktori paneel","common":{"editorHelp":"Abi saamiseks vajuta ALT 0","browseServer":"Serveri sirvimine","url":"URL","protocol":"Protokoll","upload":"Laadi üles","uploadSubmit":"Saada serverisse","image":"Pilt","form":"Vorm","checkbox":"Märkeruut","radio":"Raadionupp","textField":"Tekstilahter","textarea":"Tekstiala","hiddenField":"Varjatud lahter","button":"Nupp","select":"Valiklahter","imageButton":"Piltnupp","notSet":"<määramata>","id":"ID","name":"Nimi","langDir":"Keele suund","langDirLtr":"Vasakult paremale (LTR)","langDirRtl":"Paremalt vasakule (RTL)","langCode":"Keele kood","longDescr":"Pikk kirjeldus URL","cssClass":"Stiilistiku klassid","advisoryTitle":"Soovituslik pealkiri","cssStyle":"Laad","ok":"Olgu","cancel":"Loobu","close":"Sulge","preview":"Eelvaade","resize":"Suuruse muutmiseks lohista","generalTab":"Üldine","advancedTab":"Täpsemalt","validateNumberFailed":"See väärtus pole number.","confirmNewPage":"Kõik salvestamata muudatused lähevad kaotsi. Kas oled kindel, et tahad laadida uue lehe?","confirmCancel":"Mõned valikud on muudetud. Kas oled kindel, et tahad dialoogi sulgeda?","options":"Valikud","target":"Sihtkoht","targetNew":"Uus aken (_blank)","targetTop":"Kõige ülemine aken (_top)","targetSelf":"Sama aken (_self)","targetParent":"Vanemaken (_parent)","langDirLTR":"Vasakult paremale (LTR)","langDirRTL":"Paremalt vasakule (RTL)","styles":"Stiili","cssClasses":"Stiililehe klassid","width":"Laius","height":"Kõrgus","align":"Joondus","left":"Vasak","right":"Paremale","center":"Kesk","justify":"Rööpjoondus","alignLeft":"Vasakjoondus","alignRight":"Paremjoondus","alignCenter":"Keskjoondus","alignTop":"Üles","alignMiddle":"Keskele","alignBottom":"Alla","alignNone":"Pole","invalidValue":"Vigane väärtus.","invalidHeight":"Kõrgus peab olema number.","invalidWidth":"Laius peab olema number.","invalidLength":"Välja \"%1\" väärtus peab olema positiivne arv korrektse ühikuga (%2) või ilma.","invalidCssLength":"\"%1\" välja jaoks määratud väärtus peab olema positiivne täisarv CSS ühikuga (px, %, in, cm, mm, em, ex, pt või pc) või ilma.","invalidHtmlLength":"\"%1\" välja jaoks määratud väärtus peab olema positiivne täisarv HTML ühikuga (px või %) või ilma.","invalidInlineStyle":"Reasisese stiili määrangud peavad koosnema paarisväärtustest (tuples), mis on semikoolonitega eraldatult järgnevas vormingus: \"nimi : väärtus\".","cssLengthTooltip":"Sisesta väärtus pikslites või number koos sobiva CSS-i ühikuga (px, %, in, cm, mm, em, ex, pt või pc).","unavailable":"%1<span class=\"cke_accessibility\">, pole saadaval</span>","keyboard":{"8":"Backspace","13":"Enter","16":"Shift","17":"Ctrl","18":"Alt","32":"Tühik","35":"End","36":"Home","46":"Kustuta","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Command"},"keyboardShortcut":"Kiirklahv","optionDefault":"Vaikeväärtus"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Kõik õigused kaitstud.","dlgTitle":"CKEditor 4st lähemalt","moreInfo":"Litsentsi andmed leiab meie veebilehelt:"},"basicstyles":{"bold":"Paks","italic":"Kursiiv","strike":"Läbijoonitud","subscript":"Allindeks","superscript":"Ülaindeks","underline":"Allajoonitud"},"bidi":{"ltr":"Teksti suund vasakult paremale","rtl":"Teksti suund paremalt vasakule"},"blockquote":{"toolbar":"Blokktsitaat"},"notification":{"closed":"Teavitused on suletud."},"toolbar":{"toolbarCollapse":"Tööriistariba peitmine","toolbarExpand":"Tööriistariba näitamine","toolbarGroups":{"document":"Dokument","clipboard":"Lõikelaud/tagasivõtmine","editing":"Muutmine","forms":"Vormid","basicstyles":"Põhistiilid","paragraph":"Lõik","links":"Lingid","insert":"Sisesta","styles":"Stiilid","colors":"Värvid","tools":"Tööriistad"},"toolbars":"Redaktori tööriistaribad"},"clipboard":{"copy":"Kopeeri","copyError":"Sinu veebisirvija turvaseaded ei luba redaktoril automaatselt kopeerida. Palun kasutage selleks klaviatuuri klahvikombinatsiooni (Ctrl/Cmd+C).","cut":"Lõika","cutError":"Sinu veebisirvija turvaseaded ei luba redaktoril automaatselt lõigata. Palun kasutage selleks klaviatuuri klahvikombinatsiooni (Ctrl/Cmd+X).","paste":"Aseta","pasteNotification":"Asetamiseks vajuta %1. Sinu brauser ei toeta asetamist tööriistariba nupu või kontekstimenüü valikuga.","pasteArea":"Asetamise ala","pasteMsg":"Aseta sisu alumisse kasti ja vajuta OK nupule.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Automaatne","bgColorTitle":"Tausta värv","colors":{"000":"Must","800000":"Kastanpruun","8B4513":"Sadulapruun","2F4F4F":"Tume paehall","008080":"Sinakasroheline","000080":"Meresinine","4B0082":"Indigosinine","696969":"Tumehall","B22222":"Šamottkivi","A52A2A":"Pruun","DAA520":"Kuldkollane","006400":"Tumeroheline","40E0D0":"Türkiissinine","0000CD":"Keskmine sinine","800080":"Lilla","808080":"Hall","F00":"Punanae","FF8C00":"Tumeoranž","FFD700":"Kuldne","008000":"Roheline","0FF":"Tsüaniidsinine","00F":"Sinine","EE82EE":"Violetne","A9A9A9":"Tumehall","FFA07A":"Hele lõhe","FFA500":"Oranž","FFFF00":"Kollane","00FF00":"Lubja hall","AFEEEE":"Kahvatu türkiis","ADD8E6":"Helesinine","DDA0DD":"Ploomililla","D3D3D3":"Helehall","FFF0F5":"Lavendlipunane","FAEBD7":"Antiikvalge","FFFFE0":"Helekollane","F0FFF0":"Meloniroheline","F0FFFF":"Taevasinine","F0F8FF":"Beebisinine","E6E6FA":"Lavendel","FFF":"Valge","1ABC9C":"Tugev taevasinine","2ECC71":"Smaragdroheline","3498DB":"Kirgas sinine","9B59B6":"Ametüst","4E5F70":"Hallikassinine","F1C40F":"Erkkollane","16A085":"Tume taevasinine","27AE60":"Tumeroheline","2980B9":"Tugev sinine","8E44AD":"Tumevioletne","2C3E50":"Hallikassinine","F39C12":"Oraanž","E67E22":"Porgand","E74C3C":"Kahvatu punane","ECF0F1":"Kirgas hõbedane","95A5A6":"Hele hallikas taevasinine","DDD":"Helehall","D35400":"Kõrvitsavärv","C0392B":"Tugev punane","BDC3C7":"Hõbedane","7F8C8D":"Hallikas taevasinine","999":"Tume hall"},"more":"Rohkem värve...","panelTitle":"Värvid","textColorTitle":"Teksti värv"},"colordialog":{"clear":"Eemalda","highlight":"Näidis","options":"Värvi valikud","selected":"Valitud värv","title":"Värvi valimine"},"templates":{"button":"Mall","emptyListMsg":"(Ühtegi malli ei ole defineeritud)","insertOption":"Praegune sisu asendatakse","options":"Malli valikud","selectPromptMsg":"Palun vali mall, mis avada redaktoris<br />(praegune sisu läheb kaotsi):","title":"Sisumallid"},"contextmenu":{"options":"Kontekstimenüü valikud"},"copyformatting":{"label":"Kopeeri vorming","notification":{"copied":"Vorming on kopeeritud","applied":"Vorming on rakendatud","canceled":"Vormindamisest loobuti","failed":"Vormindamine nurjus. Stiile ei saa rakendada ilma neid enne kopeerimata."}},"div":{"IdInputLabel":"ID","advisoryTitleInputLabel":"Soovitatav pealkiri","cssClassInputLabel":"Stiililehe klassid","edit":"Muuda Div","inlineStyleInputLabel":"Reasisene stiil","langDirLTRLabel":"Vasakult paremale (LTR)","langDirLabel":"Keele suund","langDirRTLLabel":"Paremalt vasakule (RTL)","languageCodeInputLabel":" Keelekood","remove":"Eemalda Div","styleSelectLabel":"Stiil","title":"Div-konteineri loomine","toolbar":"Div-konteineri loomine"},"elementspath":{"eleLabel":"Elementide asukoht","eleTitle":"%1 element"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Faili lugemisel esines viga.","networkError":"Faili üleslaadimisel esines võrgu viga.","httpError404":"Faili üleslaadimisel esines HTTP viga (404: faili ei leitud).","httpError403":"Faili üleslaadimisel esines HTTP viga (403: keelatud).","httpError":"Faili üleslaadimisel esines HTTP viga (veakood: %1).","noUrlError":"Üleslaadimise URL ei ole määratud.","responseError":"Vigane serveri vastus."},"find":{"find":"Otsi","findOptions":"Otsingu valikud","findWhat":"Otsitav:","matchCase":"Suur- ja väiketähtede eristamine","matchCyclic":"Jätkatakse algusest","matchWord":"Ainult terved sõnad","notFoundMsg":"Otsitud teksti ei leitud.","replace":"Asenda","replaceAll":"Asenda kõik","replaceSuccessMsg":"%1 vastet asendati.","replaceWith":"Asendus:","title":"Otsimine ja asendamine"},"font":{"fontSize":{"label":"Suurus","voiceLabel":"Kirja suurus","panelTitle":"Suurus"},"label":"Kiri","panelTitle":"Kiri","voiceLabel":"Kiri"},"fakeobjects":{"anchor":"Ankur","hiddenfield":"Varjatud väli","iframe":"IFrame","unknown":"Tundmatu objekt"},"forms":{"button":{"title":"Nupu omadused","text":"Tekst (väärtus)","type":"Liik","typeBtn":"Nupp","typeSbm":"Saada","typeRst":"Lähtesta"},"checkboxAndRadio":{"checkboxTitle":"Märkeruudu omadused","radioTitle":"Raadionupu omadused","value":"Väärtus","selected":"Märgitud","required":"Nõutud"},"form":{"title":"Vormi omadused","menu":"Vormi omadused","action":"Toiming","method":"Meetod","encoding":"Kodeering"},"hidden":{"title":"Varjatud lahtri omadused","name":"Nimi","value":"Väärtus"},"select":{"title":"Valiklahtri omadused","selectInfo":"Info","opAvail":"Võimalikud valikud:","value":"Väärtus","size":"Suurus","lines":"ridu","chkMulti":"Võimalik mitu valikut","required":"Nõutud","opText":"Tekst","opValue":"Väärtus","btnAdd":"Lisa","btnModify":"Muuda","btnUp":"Üles","btnDown":"Alla","btnSetValue":"Määra vaikimisi","btnDelete":"Kustuta"},"textarea":{"title":"Tekstiala omadused","cols":"Veerge","rows":"Ridu"},"textfield":{"title":"Tekstilahtri omadused","name":"Nimi","value":"Väärtus","charWidth":"Laius (tähemärkides)","maxChars":"Maksimaalselt tähemärke","required":"õutud","type":"Liik","typeText":"Tekst","typePass":"Parool","typeEmail":"E-mail","typeSearch":"Otsi","typeTel":"Telefon","typeUrl":"URL"}},"format":{"label":"Vorming","panelTitle":"Vorming","tag_address":"Aadress","tag_div":"Tavaline (DIV)","tag_h1":"Pealkiri 1","tag_h2":"Pealkiri 2","tag_h3":"Pealkiri 3","tag_h4":"Pealkiri 4","tag_h5":"Pealkiri 5","tag_h6":"Pealkiri 6","tag_p":"Tavaline","tag_pre":"Vormindatud"},"horizontalrule":{"toolbar":"Horisontaaljoone sisestamine"},"iframe":{"border":"Raami äärise näitamine","noUrl":"Vali iframe URLi liik","scrolling":"Kerimisribade lubamine","title":"IFrame omadused","toolbar":"IFrame","tabindex":"Remove from tabindex"},"image":{"alt":"Alternatiivne tekst","border":"Joon","btnUpload":"Saada serverisse","button2Img":"Kas tahad teisendada valitud pildiga nupu tavaliseks pildiks?","hSpace":"H. vaheruum","img2Button":"Kas tahad teisendada valitud tavalise pildi pildiga nupuks?","infoTab":"Pildi info","linkTab":"Link","lockRatio":"Lukusta kuvasuhe","menu":"Pildi omadused","resetSize":"Lähtesta suurus","title":"Pildi omadused","titleButton":"Piltnupu omadused","upload":"Lae üles","urlMissing":"Pildi lähte-URL on puudu.","vSpace":"V. vaheruum","validateBorder":"Äärise laius peab olema täisarv.","validateHSpace":"Horisontaalne vaheruum peab olema täisarv.","validateVSpace":"Vertikaalne vaheruum peab olema täisarv."},"indent":{"indent":"Taande suurendamine","outdent":"Taande vähendamine"},"smiley":{"options":"Emotikonide valikud","title":"Sisesta emotikon","toolbar":"Emotikon"},"language":{"button":"Määra keel","remove":"Eemalda keel"},"link":{"acccessKey":"Juurdepääsu võti","advanced":"Täpsemalt","advisoryContentType":"Juhendava sisu tüüp","advisoryTitle":"Juhendav tiitel","anchor":{"toolbar":"Ankru sisestamine/muutmine","menu":"Ankru omadused","title":"Ankru omadused","name":"Ankru nimi","errorName":"Palun sisesta ankru nimi","errorWhitespace":"Anchor name cannot contain space characters","remove":"Eemalda ankur"},"anchorId":"Elemendi id järgi","anchorName":"Ankru nime järgi","charset":"Lingitud ressursi märgistik","cssClasses":"Stiilistiku klassid","download":"Sunni allalaadimine","displayText":"Näidatav tekst","emailAddress":"E-posti aadress","emailBody":"Sõnumi tekst","emailSubject":"Sõnumi teema","id":"ID","info":"Lingi info","langCode":"Keele suund","langDir":"Keele suund","langDirLTR":"Vasakult paremale (LTR)","langDirRTL":"Paremalt vasakule (RTL)","menu":"Muuda linki","name":"Nimi","noAnchors":"(Selles dokumendis pole ankruid)","noEmail":"Palun kirjuta e-posti aadress","noUrl":"Palun kirjuta lingi URL","noTel":"Palun sisesta telefoninumber","other":"<muu>","phoneNumber":"Telefoninumber","popupDependent":"Sõltuv (Netscape)","popupFeatures":"Hüpikakna omadused","popupFullScreen":"Täisekraan (IE)","popupLeft":"Vasak asukoht","popupLocationBar":"Aadressiriba","popupMenuBar":"Menüüriba","popupResizable":"Suurust saab muuta","popupScrollBars":"Kerimisribad","popupStatusBar":"Olekuriba","popupToolbar":"Tööriistariba","popupTop":"Ülemine asukoht","rel":"Suhe","selectAnchor":"Vali ankur","styles":"Laad","tabIndex":"Tab indeks","target":"Sihtkoht","targetFrame":"<raam>","targetFrameName":"Sihtmärk raami nimi","targetPopup":"<hüpikaken>","targetPopupName":"Hüpikakna nimi","title":"Link","toAnchor":"Ankur sellel lehel","toEmail":"E-post","toUrl":"URL","toPhone":"Telefon","toolbar":"Lingi lisamine/muutmine","type":"Lingi liik","unlink":"Lingi eemaldamine","upload":"Lae üles"},"list":{"bulletedlist":"Punktloend","numberedlist":"Numberloend"},"liststyle":{"bulletedTitle":"Punktloendi omadused","circle":"Ring","decimal":"Numbrid (1, 2, 3, jne)","disc":"Täpp","lowerAlpha":"Väiketähed (a, b, c, d, e, jne)","lowerRoman":"Väiksed rooma numbrid (i, ii, iii, iv, v, jne)","none":"Puudub","notset":"<pole määratud>","numberedTitle":"Numberloendi omadused","square":"Ruut","start":"Algus","type":"Liik","upperAlpha":"Suurtähed (A, B, C, D, E, jne)","upperRoman":"Suured rooma numbrid (I, II, III, IV, V, jne)","validateStartNumber":"Loendi algusnumber peab olema täisarv."},"magicline":{"title":"Sisesta siia lõigu tekst"},"maximize":{"maximize":"Maksimeerimine","minimize":"Minimeerimine"},"newpage":{"toolbar":"Uus leht"},"pagebreak":{"alt":"Lehevahetuskoht","toolbar":"Lehevahetuskoha sisestamine"},"pastetext":{"button":"Asetamine tavalise tekstina","pasteNotification":"Asetamiseks vajuta %1. Sinu brauser ei toeta asetamist tööriistariba nupu või kontekstimenüü valikuga.","title":"Asetamine tavalise tekstina"},"pastefromword":{"confirmCleanup":"Tekst, mida tahad asetada näib pärinevat Wordist. Kas tahad selle enne asetamist puhastada?","error":"Asetatud andmete puhastamine ei olnud sisemise vea tõttu võimalik","title":"Asetamine Wordist","toolbar":"Asetamine Wordist"},"preview":{"preview":"Eelvaade"},"print":{"toolbar":"Printimine"},"removeformat":{"toolbar":"Vormingu eemaldamine"},"save":{"toolbar":"Salvestamine"},"selectall":{"toolbar":"Kõige valimine"},"showblocks":{"toolbar":"Blokkide näitamine"},"sourcearea":{"toolbar":"Lähtekood"},"specialchar":{"options":"Erimärkide valikud","title":"Erimärgi valimine","toolbar":"Erimärgi sisestamine"},"scayt":{"btn_about":"SCAYT-ist lähemalt","btn_dictionaries":"Sõnaraamatud","btn_disable":"SCAYT keelatud","btn_enable":"SCAYT lubatud","btn_langs":"Keeled","btn_options":"Valikud","text_title":"Õigekirjakontroll kirjutamise ajal"},"stylescombo":{"label":"Stiil","panelTitle":"Vormindusstiilid","panelTitle1":"Blokkstiilid","panelTitle2":"Reasisesed stiilid","panelTitle3":"Objektistiilid"},"table":{"border":"Joone suurus","caption":"Tabeli tiitel","cell":{"menu":"Lahter","insertBefore":"Sisesta lahter enne","insertAfter":"Sisesta lahter peale","deleteCell":"Eemalda lahtrid","merge":"Ühenda lahtrid","mergeRight":"Ühenda paremale","mergeDown":"Ühenda alla","splitHorizontal":"Poolita lahter horisontaalselt","splitVertical":"Poolita lahter vertikaalselt","title":"Lahtri omadused","cellType":"Lahtri liik","rowSpan":"Ridade vahe","colSpan":"Tulpade vahe","wordWrap":"Sõnade murdmine","hAlign":"Horisontaalne joondus","vAlign":"Vertikaalne joondus","alignBaseline":"Baasjoon","bgColor":"Tausta värv","borderColor":"Äärise värv","data":"Andmed","header":"Päis","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Jah","no":"Ei","invalidWidth":"Lahtri laius peab olema number.","invalidHeight":"Lahtri kõrgus peab olema number.","invalidRowSpan":"Ridade vahe peab olema täisarv.","invalidColSpan":"Tulpade vahe peab olema täisarv.","chooseColor":"Vali"},"cellPad":"Lahtri täidis","cellSpace":"Lahtri vahe","column":{"menu":"Veerg","insertBefore":"Sisesta veerg enne","insertAfter":"Sisesta veerg peale","deleteColumn":"Eemalda veerud"},"columns":"Veerud","deleteTable":"Kustuta tabel","headers":"Päised","headersBoth":"Mõlemad","headersColumn":"Esimene tulp","headersNone":"Puudub","headersRow":"Esimene rida","heightUnit":"kõrgusühik","invalidBorder":"Äärise suurus peab olema number.","invalidCellPadding":"Lahtrite polsterdus (padding) peab olema positiivne arv.","invalidCellSpacing":"Lahtrite vahe peab olema positiivne arv.","invalidCols":"Tulpade arv peab olema nullist suurem.","invalidHeight":"Tabeli kõrgus peab olema number.","invalidRows":"Ridade arv peab olema nullist suurem.","invalidWidth":"Tabeli laius peab olema number.","menu":"Tabeli omadused","row":{"menu":"Rida","insertBefore":"Sisesta rida enne","insertAfter":"Sisesta rida peale","deleteRow":"Eemalda read"},"rows":"Read","summary":"Kokkuvõte","title":"Tabeli omadused","toolbar":"Tabel","widthPc":"protsenti","widthPx":"pikslit","widthUnit":"laiuse ühik"},"undo":{"redo":"Toimingu kordamine","undo":"Tagasivõtmine"},"widget":{"move":"Liigutamiseks klõpsa ja lohista","label":"%1 vidin"},"uploadwidget":{"abort":"Kasutaja katkestas üleslaadimise.","doneOne":"Fail on üles laaditud.","doneMany":"%1 faili laaditi edukalt üles.","uploadOne":"Faili üleslaadimine ({percentage}%)...","uploadMany":"Failide üleslaadimine, {current} fail {max}-st üles laaditud ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Lähtekood","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Otsi emotikoni...","searchLabel":"Lahter, mille abil paneelil otsida ja filtreerida emotikone.","navigationLabel":"Emotikonide gruppide vahel liikumine.","title":"Emotikonide loend","groups":{"people":"Inimesed","nature":"Loodus ja loomad","food":"Toit ja joogid","travel":"Reisimine ja kohad","activities":"Tegevused","objects":"Asjad","symbols":"Sümbolid","flags":"Lipud"}},"html5video":{"button":"Insert HTML5 video","title":"HTML5 video","infoLabel":"Video info","allowed":"Allowed file extensions: MP4, WebM, Ogv","urlMissing":"Video source URL is missing.","videoProperties":"Video properties","upload":"Upload","btnUpload":"Send it to the server","advanced":"Advanced","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Yes","no":"No","loop":"Loop?","responsive":"Responsive width","controls":"Show controls","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Lähtekood","title":"Lähtekood"}};